/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.rcs.sas.ClientLocation;
import com.ibm.hwmca.fw.rcs.sas.CompanyIdentifier;
import com.ibm.hwmca.fw.rcs.sas.LicenseAcceptance;
import com.ibm.hwmca.fw.rcs.sas.PSeriesEnrollment;
import com.ibm.hwmca.fw.rcs.sas.RegisterUsers;
import com.ibm.hwmca.fw.rcs.sas.SasTransactionException;
import com.ibm.hwmca.fw.rcs.sas.SasXmlException;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rcs.sas.SystemIdentifier;
import com.ibm.hwmca.fw.rcs.sas.XSeriesEnrollment;
import com.ibm.hwmca.fw.rcs.sas.ZSeriesEnrollment;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SystemAuthentication {
    private static final String TRACE_MASKT = "XSASSAUT";
    private static final String TRACE_MASKF = "XSASSAUF";
    private static final String TRACE_MASKD = "XSASSAUD";
    public static final String PLATFORM_OS390 = "OS390";
    public static final String PLATFORM_S390HMC = "S390HMC";
    public static final String PLATFORM_AS400 = "AS400";
    public static final String PLATFORM_RS6000 = "RS6000";
    public static final String PLATFORM_NETFINITY = "Netfinity";
    public static final String PLATFORM_IBM3890 = "IBM3890";
    public static final String PLATFORM_MPSA = "MPSA";
    public static final String CLIENT_VERSION_1_0 = "1.0";
    private static final String VERSION_TAG = "<?xml version=\"1.0\"?>";
    private static final String DOCTYPE_TAG = "<!DOCTYPE sessionless-sdr-request-v2 SYSTEM \"sessionless-sdr-request-v2.dtd\">";
    private static final String REQUEST_START_TAG = "<sessionless-sdr-request-v2>";
    private static final String REQUEST_END_TAG = "</sessionless-sdr-request-v2>";
    private static final String ENROLLMENT = "enrollment";
    private static final String ENROLLMENT_UPDATE = "enrollment-update";
    private static final String PLATFORM = "platform";
    private static final String SENDING_SYSTEM = "sending-system";
    private static final String OWNING_SYSTEM = "owning-system";
    private static final String MACHINE_ID = "machine-id";
    private static final String PASSWORD = "password";
    private static final String PASSWORD_CHANGE = "password-change";
    private static final String REQUEST_TOKEN = "request-token";
    private static final String CLIENT_VERSION = "client-version";
    private static final String CARRIAGE_RETURN_LINE_FEED = "\r\n";
    private static String clientVersion = "1.0";
    private static String platform = "S390HMC";

    public static SysInfo enrollSystem(TcpConnection tcpConnection, SystemIdentifier systemIdentifier, ClientLocation clientLocation, CompanyIdentifier companyIdentifier, LicenseAcceptance licenseAcceptance, RegisterUsers registerUsers, XSeriesEnrollment xseriesEnrollment, ZSeriesEnrollment zseriesEnrollment, PSeriesEnrollment pseriesEnrollment) throws IOException, SasTransactionException, SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.enrollSystem(tcpConnection= " + tcpConnection + ", " + "systemIdentifier= " + systemIdentifier + ", " + "clientLocation= " + clientLocation + ", " + "companyIdentifier= " + companyIdentifier + ", " + "licenseAcceptance= " + licenseAcceptance + ", " + "registerUsers= " + registerUsers + ", " + "xseriesEnrollment= " + xseriesEnrollment + ", " + "zseriesEnrollment= " + zseriesEnrollment + ", " + "pseriesEnrollment= " + pseriesEnrollment + ")");
        SysInfo sysInfo = null;
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(VERSION_TAG);
        buffer.append(DOCTYPE_TAG);
        buffer.append(REQUEST_START_TAG);
        buffer.append("<enrollment platform=\"" + platform + "\"" + ">");
        buffer.append(systemIdentifier.toXml());
        buffer.append(clientLocation.toXml());
        buffer.append(companyIdentifier.toXml());
        if (licenseAcceptance != null) {
            buffer.append(licenseAcceptance.toXml());
        }
        if (registerUsers != null) {
            buffer.append(registerUsers.toXml());
        }
        if (xseriesEnrollment != null) {
            buffer.append(xseriesEnrollment.toXml());
        }
        if (zseriesEnrollment != null) {
            buffer.append(zseriesEnrollment.toXml());
        }
        if (pseriesEnrollment != null) {
            buffer.append(pseriesEnrollment.toXml());
        }
        buffer.append("</enrollment>");
        buffer.append(REQUEST_END_TAG);
        buffer.append(CARRIAGE_RETURN_LINE_FEED);
        String sessionlessRequest = SystemAuthentication.createHttpHeader(buffer.toString().length()) + buffer.toString();
        String sessionlessReturn = SystemAuthentication.sendSasRequest(tcpConnection, sessionlessRequest);
        sysInfo = SystemAuthentication.parseEnrollmentOutput(sessionlessReturn);
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.enrollSystem()");
        return sysInfo;
    }

    public static void updateSystem(TcpConnection tcpConnection, SysInfo sendingSystem, SysInfo owningSystem, SystemIdentifier systemIdentifier, ClientLocation clientLocation, CompanyIdentifier companyIdentifier, LicenseAcceptance licenseAcceptance, RegisterUsers registerUsers, XSeriesEnrollment xseriesEnrollment, ZSeriesEnrollment zseriesEnrollment, PSeriesEnrollment pseriesEnrollment) throws IOException, SasTransactionException, SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.updateSystem(tcpConnection= " + tcpConnection + ", " + "sendingSystem= " + sendingSystem + ", " + "owningSystem= " + owningSystem + ", " + "systemIdentifier= " + systemIdentifier + ", " + "clientLocation= " + clientLocation + ", " + "companyIdentifier= " + companyIdentifier + ", " + "licenseAcceptance= " + licenseAcceptance + ", " + "registerUsers= " + registerUsers + ", " + "xseriesEnrollment= " + xseriesEnrollment + ", " + "zseriesEnrollment= " + zseriesEnrollment + ", " + "pseriesEnrollment= " + pseriesEnrollment + ")");
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(VERSION_TAG);
        buffer.append(DOCTYPE_TAG);
        buffer.append(REQUEST_START_TAG);
        buffer.append("<sending-system machine-id=\"" + sendingSystem.getMachineId() + "\"" + " " + PASSWORD + "=\"" + sendingSystem.getPassword() + "\"" + " " + CLIENT_VERSION + "=\"" + clientVersion + "\"" + "/>");
        buffer.append("<owning-system machine-id=\"" + owningSystem.getMachineId() + "\"" + " " + PASSWORD + "=\"" + owningSystem.getPassword() + "\"" + " " + CLIENT_VERSION + "=\"" + clientVersion + "\"" + "/>");
        buffer.append("<enrollment-update>");
        buffer.append(systemIdentifier.toXml());
        buffer.append(clientLocation.toXml());
        buffer.append(companyIdentifier.toXml());
        if (licenseAcceptance != null) {
            buffer.append(licenseAcceptance.toXml());
        }
        if (registerUsers != null) {
            buffer.append(registerUsers.toXml());
        }
        if (xseriesEnrollment != null) {
            buffer.append(xseriesEnrollment.toXml());
        }
        if (zseriesEnrollment != null) {
            buffer.append(zseriesEnrollment.toXml());
        }
        if (pseriesEnrollment != null) {
            buffer.append(pseriesEnrollment.toXml());
        }
        buffer.append("</enrollment-update>");
        buffer.append(REQUEST_END_TAG);
        buffer.append(CARRIAGE_RETURN_LINE_FEED);
        String sessionlessRequest = SystemAuthentication.createHttpHeader(buffer.toString().length()) + buffer.toString();
        String sessionlessReturn = SystemAuthentication.sendSasRequest(tcpConnection, sessionlessRequest);
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.updateSystem()");
    }

    public static SysInfo updatePassword(TcpConnection tcpConnection, SysInfo sendingSystem, SysInfo owningSystem) throws IOException, SasTransactionException, SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.updatePassword(tcpConnection= " + tcpConnection + "sendingSystem= " + sendingSystem + ", " + "owningSystem= " + owningSystem + ")");
        SysInfo sysInfo = null;
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(VERSION_TAG);
        buffer.append(DOCTYPE_TAG);
        buffer.append(REQUEST_START_TAG);
        buffer.append("<sending-system machine-id=\"" + sendingSystem.getMachineId() + "\"" + " " + PASSWORD + "=\"" + sendingSystem.getPassword() + "\"" + " " + CLIENT_VERSION + "=\"" + clientVersion + "\"" + "/>");
        buffer.append("<owning-system machine-id=\"" + owningSystem.getMachineId() + "\"" + " " + PASSWORD + "=\"" + owningSystem.getPassword() + "\"" + " " + CLIENT_VERSION + "=\"" + clientVersion + "\"" + "/>");
        buffer.append("<password-change>");
        buffer.append("</password-change>");
        buffer.append(REQUEST_END_TAG);
        buffer.append(CARRIAGE_RETURN_LINE_FEED);
        String sessionlessRequest = SystemAuthentication.createHttpHeader(buffer.toString().length()) + buffer.toString();
        String sessionlessReturn = SystemAuthentication.sendSasRequest(tcpConnection, sessionlessRequest);
        sysInfo = SystemAuthentication.parseEnrollmentOutput(sessionlessReturn);
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.updatePassword()");
        return sysInfo;
    }

    public static String getToken(TcpConnection tcpConnection, SysInfo sendingSystem, SysInfo owningSystem) throws IOException, SasTransactionException, SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.getToken(tcpConnection= " + tcpConnection + ", " + "sendingSystem= " + sendingSystem + ", " + "owningSystem= " + owningSystem + ")");
        String token = "";
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(VERSION_TAG);
        buffer.append(DOCTYPE_TAG);
        buffer.append(REQUEST_START_TAG);
        buffer.append("<sending-system machine-id=\"" + sendingSystem.getMachineId() + "\"" + " " + PASSWORD + "=\"" + sendingSystem.getPassword() + "\"" + " " + CLIENT_VERSION + "=\"" + clientVersion + "\"" + "/>");
        buffer.append("<owning-system machine-id=\"" + owningSystem.getMachineId() + "\"" + " " + PASSWORD + "=\"" + owningSystem.getPassword() + "\"" + " " + CLIENT_VERSION + "=\"" + clientVersion + "\"" + "/>");
        buffer.append("<request-token>");
        buffer.append("</request-token>");
        buffer.append(REQUEST_END_TAG);
        buffer.append(CARRIAGE_RETURN_LINE_FEED);
        String sessionlessRequest = SystemAuthentication.createHttpHeader(buffer.toString().length()) + buffer.toString();
        String sessionlessReturn = SystemAuthentication.sendSasRequest(tcpConnection, sessionlessRequest);
        token = SystemAuthentication.parseToken(sessionlessReturn);
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.getToken()");
        return token;
    }

    private static String sendSasRequest(TcpConnection tcpConnection, String request) throws IOException, SasTransactionException, SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.sendSasRequest(tcpConnection= " + tcpConnection + "request= " + request + ")");
        StringBuffer response = new StringBuffer(1000);
        Socket socket = null;
        BufferedReader bufferedReader = null;
        PrintStream printStream = null;
        socket = tcpConnection.getSocket();
        printStream = new PrintStream(socket.getOutputStream());
        printStream.print(request);
        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String httpHeader = "";
        String line = null;
        boolean firstTime = true;
        int lineCount = 0;
        while ((line = bufferedReader.readLine()) != null) {
            Trace.trace(TRACE_MASKD, "SystemAuthentication.sendSasRequest(): line = " + ++lineCount + " [" + line + "]");
            if (line.length() == 0 && firstTime) {
                httpHeader = new String(response);
                response.setLength(0);
                firstTime = false;
                continue;
            }
            if (line.indexOf("sessionless-sdr-return-v2.dtd") < 0) {
                response.append(line);
                response.append(CARRIAGE_RETURN_LINE_FEED);
                continue;
            }
            int begin = line.indexOf("SYSTEM");
            int end = line.lastIndexOf("\"");
            line = line.substring(0, begin) + line.substring(end + 1, line.length());
            response.append(line);
            response.append(CARRIAGE_RETURN_LINE_FEED);
        }
        printStream.close();
        bufferedReader.close();
        socket.close();
        StringTokenizer stringTokenizer = new StringTokenizer(httpHeader, " ");
        stringTokenizer.nextToken();
        String httpReturnCode = stringTokenizer.nextToken();
        Trace.trace(TRACE_MASKF, "SystemAuthentication.sendSasRequest(): HTTP return code = " + httpReturnCode);
        if (httpReturnCode.equals("200")) {
            String returnCode = SystemAuthentication.parseReturnCode(response.toString());
            Trace.trace(TRACE_MASKF, "SystemAuthentication.sendSasRequest(): return-code = " + returnCode);
            if (!returnCode.equals("100")) {
                if (!(returnCode.equals("2000") || returnCode.equals("2100") || returnCode.equals("3000"))) {
                    if (returnCode.equals("5000")) {
                        String reasonCode = SystemAuthentication.parseReasonCode(response.toString());
                        Trace.trace(TRACE_MASKF, "SystemAuthentication.sendSasRequest(): reason-code = " + reasonCode);
                        if (reasonCode.equals("9970")) {
                            Trace.trace(TRACE_MASKF, "SystemAuthentication.sendSasRequest(): Length of the given userid is invalid.");
                        } else if (reasonCode.equals("9972")) {
                            Trace.trace(TRACE_MASKF, "SystemAuthentication.sendSasRequest(): Illegal character within the given userid.");
                        }
                    } else if (returnCode.equals("5100") || returnCode.equals("6000") || returnCode.equals("7000") || returnCode.equals("7100") || returnCode.equals("7101") || returnCode.equals("7105") || returnCode.equals("7150") || returnCode.equals("7151") || returnCode.equals("7155") || returnCode.equals("7180") || returnCode.equals("7181")) {
                        // empty if block
                    }
                }
                throw new SasTransactionException(returnCode);
            }
        } else {
            if (httpReturnCode.length() == 3 && httpReturnCode.startsWith("3")) {
                throw new SasTransactionException(httpReturnCode);
            }
            throw new SasTransactionException(httpReturnCode);
        }
        Trace.trace(TRACE_MASKF, "SystemAuthentication.sendSasRequest(): The request was successful!");
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.sendSasRequest()");
        return response.toString();
    }

    private static String parseReturnCode(String xml) throws SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.parseReturnCode()");
        String returnCode = "";
        try {
            byte[] xmlBytes = xml.getBytes();
            Document document = new HwmcaParser(xmlBytes, false).getDocument();
            NodeList nodeList = document.getElementsByTagName("sessionless-sdr-return-v2");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                returnCode = element.getAttribute("return-code");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            throw new SasXmlException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.parseReturnCode()");
        return returnCode;
    }

    public static String parseReasonCode(String xml) throws SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.parseReasonCode()");
        String reasonCode = "";
        try {
            byte[] xmlBytes = xml.getBytes();
            Document document = new HwmcaParser(xmlBytes, false).getDocument();
            NodeList nodeList = document.getElementsByTagName("sessionless-sdr-return-v2");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                reasonCode = element.getAttribute("reason-code");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            throw new SasXmlException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.parseReasonCode()");
        return reasonCode;
    }

    private static SysInfo parseEnrollmentOutput(String xml) throws SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.parseEnrollmentOutput()");
        SysInfo sysInfo = null;
        try {
            byte[] xmlBytes = xml.getBytes();
            Document document = new HwmcaParser(xmlBytes, false).getDocument();
            NodeList nodeList = document.getElementsByTagName("enrollment-output");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String uid = element.getAttribute("uid");
                String pwd = element.getAttribute("pwd");
                sysInfo = new SysInfo(uid, pwd);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            throw new SasXmlException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.parseEnrollmentOutput()");
        return sysInfo;
    }

    private static String parseToken(String xml) throws SasXmlException {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.parseToken()");
        String token = "";
        try {
            byte[] xmlBytes = xml.getBytes();
            Document document = new HwmcaParser(xmlBytes, false).getDocument();
            NodeList nodeList = document.getElementsByTagName("request-token-output");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                token = element.getAttribute("token");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            throw new SasXmlException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.parseToken(" + token + ")");
        return token;
    }

    private static String createHttpHeader(long contentLength) {
        Trace.trace(TRACE_MASKT, "-> SystemAuthentication.createHttpHeader(" + contentLength + ")");
        String httpHeader = "POST /support/electronic/itssdr/IESproxy.wss HTTP/1.0\r\nContent-Type: application/octet-stream\r\nContent-Length: " + contentLength + CARRIAGE_RETURN_LINE_FEED + "Accept: text/*, application/octet-stream\r\n" + "X-XML-Document-Name: sessionless-sdr-request-v2\r\n" + "X-XML-Character-Encoding: UTF8\r\n" + CARRIAGE_RETURN_LINE_FEED;
        Trace.trace(TRACE_MASKT, "<- SystemAuthentication.createHttpHeader()");
        return httpHeader;
    }
}

